'use strict';

angular.module('company', ['department_model', 'bank_model'])
    .factory('Company', ['$http', '$q', '$rootScope', 'STCurrentList', 'DepartmentsList', 'BanksList', function($http, $q, $rootScope, STCurrentList, DepartmentsList, BanksList){
        var Company = {
            loadData: function(){
                var deferer = $q.defer();
                var scope = this;
                $http.get(appDev + '/front/rest/company')
                    .success(function(data){
                        scope.setData(data);
                        deferer.resolve(scope.list);
                    })
                ;

                return deferer.promise;
            }
            ,setData: function(data){
                angular.extend(this, data);
            }
            ,init: function(){
                STCurrentList.loadData();
                this.STCurrentList = STCurrentList.list;

                this.departments = DepartmentsList._list;
                this.bank_service_options = BanksList._list;
            }
        }

        return Company;
    }])
;